<?php
class ControllerToolKeybin extends Controller {
  
  public function cron() {
    if ($this->config->get('keybin_logs')) {
      file_put_contents(DIR_LOGS.'keybin.log', PHP_EOL . '>> ' . date('d/m/Y H:i:s'). ' - Cron command' . PHP_EOL, FILE_APPEND | LOCK_EX);
    }
    
    $this->load->model('tool/keybin');
    $this->load->model('checkout/order');
    
    // get all orders that contains keybin products, and which is not completed
    $keybinOrders = $this->db->query("SELECT * FROM `" . DB_PREFIX . "order` WHERE `keybin_id` <> '' AND order_status_id <> '".(int) $this->config->get('keybin_complete_status')."'")->rows;
    
    $completed = 0;
    
    foreach ($keybinOrders as $order) {
      // check if keys are ready
      $allKeysReady = true;
      
      $keysQuery = $this->model_tool_keybin->api('orders/'.$order['keybin_id'].'/keys');
      
      $keysString = '';
      
      if (!empty($keysQuery) && empty($keysQuery['message'])) {
        foreach ($keysQuery as $item) {
          if (!empty($item['key'])) {
            if (substr($item['key'], 0, 5) == 'data:') {
              $keysString .= ($keysString ? "<br><br>" : '') . $item['product']['name'] . '<br><img src="'.$item['key'].'" style="max-width:100%"/>';
              // $keysString .= ($keysString ? "\n" : '') . $item['product']['name'] . ' - Image key, please check it in your account';
            } else {
              $keysString .= ($keysString ? "\n" : '') . $item['product']['name'] . ' - ' . $item['key'];
            }
            
            $this->db->query("UPDATE `" . DB_PREFIX . "order_product` SET `keybin_key` = '".$this->db->escape($item['key'])."' WHERE `order_id` = '".(int) $order['order_id']."' AND `model` = '".(int) $item['product']['id']."'");
          } else {
            $allKeysReady = false;
          }
        }
      }
      
      // if all is ok, update the order status and set the keys
      if ($allKeysReady) {
        if ($this->config->get('keybin_logs')) {
          file_put_contents(DIR_LOGS.'keybin.log', 'All keys ready, update order status' . PHP_EOL, FILE_APPEND | LOCK_EX);
        }
        
        $this->model_checkout_order->addOrderHistory($order['order_id'], $this->config->get('keybin_complete_status'), $keysString, true);
        $completed++;
      }
    }
    
    if (count($keybinOrders)) {
      echo 'Keybin process complete - Total orders: '.count($keybinOrders).' - Completed: '.$completed;
      
      if ($this->config->get('keybin_logs')) {
        file_put_contents(DIR_LOGS.'keybin.log', 'Keybin process complete - Total orders: '.count($keybinOrders).' - Completed: '.$completed . PHP_EOL, FILE_APPEND | LOCK_EX);
      }
    } else {
      echo 'No keybin orders to process';
      
      if ($this->config->get('keybin_logs')) {
        file_put_contents(DIR_LOGS.'keybin.log', 'No keybin orders to process' . PHP_EOL, FILE_APPEND | LOCK_EX);
      }
    }
  }
  
}