<?php
class ModelGkdImportTransformerKeybin extends Model {
  
  public function row_product($data) {
    $defaultAttrGroup = 'Specifications';

    if (empty($data)) {
        return array();
    }

    // Reformat data for import
    $data['languages'] = !empty($data['languages']) ? $defaultAttrGroup.':Languages:'.$data['languages'] : '';
    $data['platform'] = !empty($data['platform']['name']) ? $defaultAttrGroup.':Platform:'.$data['platform']['name'] : '';
    $data['region'] = !empty($data['region']['name']) ? $defaultAttrGroup.':Region:'.$data['region']['name'] : '';
    $data['developer'] = !empty($data['developer']) ? $defaultAttrGroup.':Developer:'.$data['developer'] : '';
    $data['publisher'] = !empty($data['publisher']) ? $defaultAttrGroup.':Publisher:'.$data['publisher'] : '';

    $newCategories = '';
    $newRequirements = [];
    $newRestrictions = [];

    if (!empty($data['categories'])) {
        foreach ($data['categories'] as $k => $v) {
            if (!empty($v['name'])) {
                $newCategories .= ($newCategories ? '>' : '') . $v['name'];
            }
        }
    }

    $data['category_1'] = isset($data['categories'][0]['name']) ? $data['categories'][0]['name'] : '';
    $data['category_2'] = isset($data['categories'][1]['name']) ? $data['categories'][1]['name'] : '';
    $data['category_3'] = isset($data['categories'][2]['name']) ? $data['categories'][2]['name'] : '';
    $data['category_4'] = isset($data['categories'][3]['name']) ? $data['categories'][3]['name'] : '';
    $data['category_5'] = isset($data['categories'][4]['name']) ? $data['categories'][4]['name'] : '';

    $data['categories'] = $newCategories;

    if (!empty($data['genres'])) {
        foreach ($data['genres'] as $k => $v) {
            if (!empty($v['name'])) {
                $data['genres'][$k] = $defaultAttrGroup.':Genres:'.$v['name'];
            }
        }
    }

    // Check if requirements is an array or object before iterating
    if (!empty($data['requirements']) && (is_array($data['requirements']) || is_object($data['requirements']))) {
        foreach ($data['requirements'] as $reqGroup => $req) {
            $reqGroup = ucfirst($reqGroup);

            foreach ($req as $reqName => $reqVal) {
                if ($reqVal === '') continue;

                $reqName = ucfirst(substr($reqName, 3));
                $newRequirements[] = 'Requirements ' . $reqGroup . ':' . $reqName . ':' . $reqVal;
            }
        }
    }

    $data['requirements'] = $newRequirements;

    // Check if restrictions is an array or object before iterating
    if (!empty($data['restrictions']) && (is_array($data['restrictions']) || is_object($data['restrictions']))) {
        foreach ($data['restrictions'] as $reqName => $reqVal) {
            if (trim($reqVal) === '') continue;

            $newRestrictions[] = $defaultAttrGroup . ':PEGI:' . ucfirst(str_replace('pegi_', '', $reqName));
        }
        
        $data['restrictions'] = $newRestrictions;
    }

    // Query to get prices
    $res = $this->model_gkd_import_tool->callAPI('https://api.keybin.net/v1/products/' . $data['id'] . '/listings', $this->request->post['import_auth'], false, false, 'data/*', 'GET', false, false);
    $data['activeStock'] = 'no';

    $data['price'] = array(
        'price' => '',
        'tierPrice' => '',
        'tierPrice2' => '',
        'minOrderQty' => '',
        'currency' => '',
    );

    if (empty($res)) {
        return $data;
    }

    foreach ($res as $r) {
        $highestStock = -1;

        if (count($r) === 1) {
            $r = $r[0];
        }

        if (is_object($r)) {
            $r = json_decode(json_encode($r), true);
        }

        if (empty($r['isActive']) || empty($r['activeStock']) || $r['activeStock'] <= 1) continue;

        // uncomment to get highest stock
        // if ($highestStock > $r['activeStock']) continue;

        $data['activeStock'] = $highestStock = $r['activeStock'];
        $data['price'] = $r['price'];

        // get the first item
        break;
    }

    return $data;
}


  
 }