<?php
class ControllerExtensionModuleKeybinWebhookMargin extends Controller {
    private $error = array();

    public function index() {
        // Load language file
        $this->load->language('extension/module/keybin_webhook_margin');
        
        // Set page title
        $this->document->setTitle($this->language->get('heading_title1'));

        // Load models
        $this->load->model('setting/setting');
        $this->load->model('catalog/category');

         // Add the menu item
        $this->load->model('user/user_group');
        $this->model_user_user_group->addPermission($this->user->getGroupId(), 'access', 'extension/module/keybin_webhook_margin');
        $this->model_user_user_group->addPermission($this->user->getGroupId(), 'modify', 'extension/module/keybin_webhook_margin');

        // Initialize variables for global margin and category margins
        $global_margin = '0';
        $category_margins = [];

        // Read current values from `keybin-webhook-margins.txt` if it exists
        $file_path = DIR_SYSTEM . '../keybin-webhook-margins.txt';
        if (file_exists($file_path)) {
            $lines = file($file_path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            foreach ($lines as $line) {
                list($id, $name, $margin) = explode(';', $line);
                if (trim($id) === 'global') {
                    $global_margin = $margin;
                } else {
                    $category_margins[] = [
                        'id' => $id,
                        'name' => $name,
                        'margin' => $margin
                    ];
                }
            }
        }

        // Save settings on POST request
if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
    // Check if category_margins is set in the POST request
    $category_margins = isset($this->request->post['category_margins']) ? $this->request->post['category_margins'] : [];

    // Prepare the data to save
    $global_margin = $this->request->post['global_margin'];
    $lines = ["global; ;" . $global_margin];

    // Loop through each category margin entry to save ID, Name, and Margin
    foreach ($category_margins as $category) {
        if (!empty($category['id'])) {
            $category_info = $this->model_catalog_category->getCategory($category['id']);
            $category_name = $category_info ? $category_info['name'] : ''; // Fallback to empty if no name found
            $margin = isset($category['margin']) ? $category['margin'] : '0'; // Default to '0' if margin is empty
            $lines[] = "{$category['id']};{$category_name};{$margin}";
        }
    }

    // Write data to file in the OpenCart root directory
    file_put_contents($file_path, implode("\n", $lines));

    // Set a success message
    $this->session->data['success'] = $this->language->get('text_success');

    // Redirect to module page
    $this->response->redirect($this->url->link('extension/module/keybin_webhook_margin', 'user_token=' . $this->session->data['user_token'], true));
}


        // Load language variables into data array for view
        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_edit'] = $this->language->get('text_edit');
        $data['entry_global_margin'] = $this->language->get('entry_global_margin');
        $data['entry_category_margin'] = $this->language->get('entry_category_margin');
        $data['entry_margin_value'] = $this->language->get('entry_margin_value');
        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');
        $data['button_add_category'] = $this->language->get('button_add_category');
        $data['button_remove'] = $this->language->get('button_remove');

        // Set error and success messages
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        // Breadcrumbs for navigation
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/module/keybin_webhook_margin', 'user_token=' . $this->session->data['user_token'], true)
        );

        // Form action and cancel links
        $data['action'] = $this->url->link('extension/module/keybin_webhook_margin', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

        // Load existing data
        $data['global_margin'] = $global_margin;
        $data['category_margins'] = $category_margins;

        // Load categories for dropdown
        $data['categories'] = $this->model_catalog_category->getCategories();

        // User token for security
        $data['user_token'] = $this->session->data['user_token'];

        // Load common elements
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        // Render the view template
        $this->response->setOutput($this->load->view('extension/module/keybin_webhook_margin', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/module/keybin_webhook_margin')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }
}
