<?php
class ControllerExtensionModuleKeybin extends Controller {
	private $error = array(); 
	private $OC_V2;
	private $token;
  
  static $LINK = 'module/keybin';
	
	public function __construct($registry) {
		parent::__construct($registry);
    
    if (version_compare(VERSION, '2.3', '>=')) {
      $this->load->language('extension/module/keybin');
      self::$LINK = 'extension/module/keybin';
    } else {
      $this->load->language('module/keybin');
    }
    
    //$this->load->model('tool/keybin');
    
    $this->token = isset($this->session->data['user_token']) ? 'user_token='.$this->session->data['user_token'] : 'token='.$this->session->data['token'];
	}
	
	public function index($form = false) {
		$data['_language'] = &$this->language;
		$data['_config'] = &$this->config;
		$data['_url'] = &$this->url;
		$data['token'] = $this->token;
		$data['OC_V2'] = version_compare(VERSION, '2', '>=');
    $asset_path = 'view/gkd/keybin/';
    $data['_img_path'] = $asset_path . 'img/';
		
    // tables
		$this->db_tables();
    
		if (!version_compare(VERSION, '2', '>=')) {
			$this->document->addStyle($asset_path.'awesome/css/font-awesome.min.css');
			$this->document->addStyle($asset_path.'bootstrap.min.css');
			$this->document->addStyle($asset_path.'bootstrap-theme.min.css');
			$this->document->addScript($asset_path.'bootstrap.min.js');
		}
    
    $this->document->addStyle($asset_path.'prettyCheckable.css');
		$this->document->addScript($asset_path.'prettyCheckable.js');
		$this->document->addStyle($asset_path.'style.css');
    
		$this->document->setTitle(strip_tags($this->language->get('heading_title')));
		$this->load->model('setting/setting');
		
    $this->load->model('setting/store');
    
		// get languages 
		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();
    
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->model_setting_setting->editSetting('module_keybin', array('module_keybin_status' => 1));
			$this->model_setting_setting->editSetting('keybin', $this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');
			
			if (version_compare(VERSION, '2', '>=')) {
				$this->response->redirect($this->url->link(self::$LINK, $this->token, 'SSL'));
			} else {
				$this->redirect($this->url->link(self::$LINK, $this->token, 'SSL'));
			}
		}
		
    $this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
    
    $data['connexion_status'] = false;
    $data['balance'] = '';
    
    // api status
    if ($this->config->get('keybin_token')) {
      $curl = curl_init();
      
      curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.keybin.net/v1/account/balance',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => array(
          'Accept: application/json',
          'PERSONAL-TOKEN:'.$this->config->get('keybin_token'),
        ),
      ));

      $response = curl_exec($curl);
      
      curl_close($curl);
      
      $response = json_decode($response, true);
      
      if (isset($response['balance'])) {
        $data['connexion_status'] = true;
        $data['balance'] = $response['balance'] . ' ' . $response['currency'];
      }
    }

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else $data['success'] = '';
		
		if (isset($this->session->data['error'])) {
			$data['error'] = $this->session->data['error'];
			unset($this->session->data['error']);
		} else $data['error'] = '';
		
		$data['heading_title'] = $this->language->get('module_title');
		
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		$data['button_add_module'] = $this->language->get('button_add_module');
		$data['button_remove'] = $this->language->get('button_remove');
    
    if (isset($this->request->post['keybin_token'])) {
			$data['keybin_token'] = $this->request->post['keybin_token'];
		} else { 
			$data['keybin_token'] = $this->config->get('keybin_token');
		}
    
    if (isset($this->request->post['keybin_order'])) {
			$data['keybin_order'] = $this->request->post['keybin_order'];
		} else { 
			$data['keybin_order'] = $this->config->get('keybin_order');
		}
    
    if (isset($this->request->post['keybin_checkprice'])) {
			$data['keybin_checkprice'] = $this->request->post['keybin_checkprice'];
		} else { 
			$data['keybin_checkprice'] = $this->config->get('keybin_checkprice');
		}
    
    if (isset($this->request->post['keybin_complete_status'])) {
			$data['keybin_complete_status'] = $this->request->post['keybin_complete_status'];
		} else { 
			$data['keybin_complete_status'] = $this->config->get('keybin_complete_status');
		}
    
    if (isset($this->request->post['keybin_failed_status'])) {
			$data['keybin_failed_status'] = $this->request->post['keybin_failed_status'];
		} else { 
			$data['keybin_failed_status'] = $this->config->get('keybin_failed_status');
		}
    
    if (isset($this->request->post['keybin_margin'])) {
			$data['keybin_margin'] = $this->request->post['keybin_margin'];
		} else { 
			$data['keybin_margin'] = $this->config->get('keybin_margin');
		}
    
    if (isset($this->request->post['keybin_logs'])) {
			$data['keybin_logs'] = $this->request->post['keybin_logs'];
		} else { 
			$data['keybin_logs'] = $this->config->get('keybin_logs');
		}
    
		if (isset($this->error['error'])) {
			$data['error'] = $this->error['error'];
		} else {
			$data['error'] = '';
		}
    
 		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
    
    $data['breadcrumbs'] = array();

    $data['breadcrumbs'][] = array(
      'text'      => $this->language->get('text_home'),
      'href'      => $this->url->link('common/home', $this->token, 'SSL'),
      'separator' => false
    );

    if (version_compare(VERSION, '3', '>=')) {
      $extension_link = $this->url->link('marketplace/extension', 'type=module&' . $this->token, 'SSL');
    } else if (version_compare(VERSION, '2.3', '>=')) {
      $extension_link = $this->url->link('extension/extension', 'type=module&' . $this->token, 'SSL');
    } else {
      $extension_link = $this->url->link('extension/module', $this->token, 'SSL');
    }
    
    $data['breadcrumbs'][] = array(
      'text'      => $this->language->get('text_module'),
      'href'      => $extension_link,
      'separator' => ' :: '
    );
  
    $data['breadcrumbs'][] = array(
      'text'      => strip_tags($this->language->get('heading_title')),
      'href'      => $this->url->link(self::$LINK, $this->token, 'SSL'),
      'separator' => ' :: '
    );
    
    $data['action'] = $this->url->link(self::$LINK, $this->token, 'SSL');
    $data['cancel'] = $extension_link;
    
		if (version_compare(VERSION, '2', '>=')) {
			$data['header'] = $this->load->controller('common/header');
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['footer'] = $this->load->controller('common/footer');
			
      if (version_compare(VERSION, '3', '>=')) {
        $this->config->set('template_engine', 'template');
        $this->response->setOutput($this->load->view('gkd/keybin', $data));
      } else {
        $this->response->setOutput($this->load->view('gkd/keybin.tpl', $data));
      }
		} else {
			$data['column_left'] = '';
			$this->data = &$data;
			$this->template = 'gkd/keybin.tpl';
			$this->children = array(
				'common/header',
				'common/footer'
			);
      
			$this->response->setOutput($this->render());
		}
	}
	
	public function install() {
		$this->db_tables();
	}
	
	public function uninstall() {}
	
	private function validate() {
		if (!$this->user->hasPermission('modify', self::$LINK)) {
			$this->error['error'] = $this->language->get('error_permission');
		}
    
		if (!$this->error)
			return true;
		return false;
	}
  
  private function db_tables() {
    if (!$this->db->query("SHOW COLUMNS FROM `" . DB_PREFIX . "product` LIKE 'keybin_listing'")->row) {
			$this->db->query("ALTER TABLE `" . DB_PREFIX . "product` ADD `keybin_listing` VARCHAR(48)");
    }
    
    if (!$this->db->query("SHOW COLUMNS FROM `" . DB_PREFIX . "product` LIKE 'keybin_disable_price'")->row) {
			$this->db->query("ALTER TABLE `" . DB_PREFIX . "product` ADD `keybin_disable_price` INT(1) DEFAULT 0");
    }
    
    if (!$this->db->query("SHOW COLUMNS FROM `" . DB_PREFIX . "product` LIKE 'keybin_disable_stock'")->row) {
			$this->db->query("ALTER TABLE `" . DB_PREFIX . "product` ADD `keybin_disable_stock`  INT(1) DEFAULT 0");
    }
    
    if (!$this->db->query("SHOW COLUMNS FROM `" . DB_PREFIX . "order` LIKE 'keybin_id'")->row) {
			$this->db->query("ALTER TABLE `" . DB_PREFIX . "order` ADD `keybin_id` VARCHAR(48)");
    }
    
    if (!$this->db->query("SHOW COLUMNS FROM `" . DB_PREFIX . "order_product` LIKE 'keybin_key'")->row) {
			$this->db->query("ALTER TABLE `" . DB_PREFIX . "order_product` ADD `keybin_key` MEDIUMTEXT");
    }
    
    $this->db->query("ALTER TABLE `" . DB_PREFIX . "order_history` MODIFY `comment` LONGTEXT");
  }
}